---------Criando a tabela temporaria
CREATE TABLE #RsPdv (CD_EMP int, CD_FILIAL INT,CD_VD INT,CD_CLI INT,CD_CLI_PBM INT,DT_VD DATETIME)

--Inserindo os dados dos clientes na tabela temporaria
DECLARE @DATA DATETIME 

SET @DATA = DATEADD(MONTH,-6,GETDATE()) -- ALTERAR REGISTROS COM DATA SUPERIOR A 6 MESES

INSERT INTO #RsPdv
SELECT DISTINCT
	PDV_VD.CD_EMP,PDV_VD.CD_FILIAL,PDV_VD.CD_VD,PDV_VD.CD_CLI,PDV_VD_IT_VD_PBM.CD_CLI_PBM,PDV_VD.DT_VD 

FROM PDV_VD INNER JOIN PDV_VD_IT_VD_PBM ON
	PDV_VD.CD_EMP = PDV_VD_IT_VD_PBM.CD_EMP AND
	PDV_VD.CD_FILIAL = PDV_VD_IT_VD_PBM.CD_FILIAL AND
	PDV_VD.CD_VD = PDV_VD_IT_VD_PBM.CD_VD 

    	
WHERE 
	PDV_VD.CD_EMP =1
	AND PDV_VD.DT_VD >=  @DATA
	AND PDV_VD.ST_VD=0
	AND PDV_VD.VLR_CONV_PBM > 0 
	AND (pdv_vd.CD_CLI_PBM IS NULL OR pdv_vd.CD_CLI_PBM <= 0)
	
--Criando variavel que vai receber o codigo do cliente
DECLARE @CD_EMP INT
DECLARE @CD_FILIAL INT
DECLARE @CD_VD INT
DECLARE @CD_CLI INT
DECLARE @CD_CLI_PBM INT

--Criando o cursos de alterao para que possamos alterar cliente a cliente

SET NOCOUNT ON
DECLARE Vendas CURSOR FAST_FORWARD FOR SELECT CD_EMP,CD_FILIAL,CD_VD,CD_CLI,CD_CLI_PBM FROM #RsPdv
OPEN Vendas
FETCH NEXT FROM Vendas INTO @CD_EMP,@CD_FILIAL,@CD_VD,@CD_CLI,@CD_CLI_PBM
WHILE @@FETCH_STATUS=0
 Begin
  UPDATE PDV_VD SET CD_CLI_PBM  = @CD_CLI_PBM   WHERE CD_EMP = @CD_EMP AND CD_FILIAL = @CD_FILIAL AND CD_VD = @CD_VD
   
  FETCH NEXT FROM Vendas INTO @CD_EMP,@CD_FILIAL,@CD_VD,@CD_CLI,@CD_CLI_PBM
 End

PRINT 'Concludo.'

--Fechando cursos
CLOSE Vendas;
--Desalocando cursos da memoria
DEALLOCATE Vendas;
--Apagando a tabela temporaria
DROP TABLE #RsPdv;
--pronto no precisa mudar a parcela